local t = Def.ActorFrame{};

-- character icon/image
local function MakePlayerCharacterIcon(pn)
	local ret = Def.ActorFrame{
		InitCommand=function(self)
			self:x( pn == PLAYER_1 and SCREEN_WIDTH*0.3 or SCREEN_WIDTH*0.7 )
			self:y( SCREEN_CENTER_Y );
		end;

		LoadActor( "CharacterIcon", pn )..{
			InitCommand=function(self)
				-- characters are offset from the rings.
				local addxVals = {
					PlayerNumber_P1 = -(SCREEN_WIDTH*0.09375),
					PlayerNumber_P2 = (SCREEN_WIDTH*0.09375),
				};
				self:addx( addxVals[pn] );
			end;
			OffCommand=cmd(linear,0.2;diffusealpha,0;);
		};
	};
	return ret;
end;

for pn in ivalues(GAMESTATE:GetHumanPlayers()) do
	t[#t+1] = MakePlayerCharacterIcon(pn);
end;

return t;